Attribute VB_Name = "Module1"
Public DX As DirectX8
Public D3D As Direct3D8
Public D3DDevice As Direct3DDevice8
Public D3DX As D3DX8 'For other stuff that D3DDev and D3D cannot do.'
Public D3DPP As D3DPRESENT_PARAMETERS 'Init Data and could be used later for Switching Modes'
Public D3DCAPS As D3DCAPS8 'Misc. Init Data'
Public D3DDM As D3DDISPLAYMODE 'Init Display Mode Data'
Public D3DTypeDevice As CONST_D3DDEVTYPE 'HAL or Reference Rasteriser'

'(Unlit and Untransformed Flexable Vertex Format (UU FVF)
Public Const FVF = D3DFVF_XYZ Or D3DFVF_NORMAL Or D3DFVF_DIFFUSE Or D3DFVF_TEX2

Private Sub Main()
    Set DX = New DX
    If Err.Number <> 0 Then
        MsgBox "DX is probably not install, replace this with a Msgbox or something"
        Exit Sub
    End If
End Sub
Public Function D3DInit(ByVal vHWND As Long, Optional ByVal vWIDTH As Long = 0, Optional ByVal vHEIGHT As Long = 0, Optional ByVal vBPP As Long = 0, Optional ByRef vFORMAT As Long = 0, Optional ByVal vDeviceType As CONST_D3DDEVTYPE = 0, Optional ByVal vBACKBUFFERS As Long = 1, Optional ByVal vDEPTHBUFFER As CONST_D3DFORMAT = D3DFMT_D16) As Long
     'InitD3D
    Set D3D = DX.Direct3DCreate
    If Err.Number Then
        D3DInit = Err.Number
        Exit Function
    End If

     'Get HAL or REF
    If vDeviceType = 0 Then
        D3DTypeDevice = D3DDEVTYPE_HAL
        D3D.GetDeviceCaps D3DADAPTER_DEFAULT, D3DTypeDevice, D3DCAPS
        If Err.Number Then
            'The HAL didn't work, let's try to get the REF
            Err.Clear
            D3DTypeDevice = D3DDEVTYPE_REF
            D3D.GetDeviceCaps D3DADAPTER_DEFAULT, D3DTypeDevice, D3DCAPS
            If Err.Number Then
                D3DInit = D3DERR_NOTAVAILABLE
                Exit Function
            End If
        End If
    Else
        D3DTypeDevice = vDeviceType
    End If

    'Display
    With D3DPP
        'Check if Window(sum=0) or fullscreen(sum<>0)
        If (vWIDTH + vHEIGHT + vBPP) = 0 Then
            'Get the Current Display Mode(D3DDM) to check for 8bit colour
            D3D.GetAdapterDisplayMode D3DADAPTER_DEFAULT, D3DDM
            'Check the D3DDM to see that the display mode's colour is higher than 8bit
            If D3DDM.Format = D3DFMT_P8 Or D3DDM.Format = D3DFMT_A8P8 Then
                'The display mode is 8bit, exit the function and return error id
                D3DInit = D3DERR_INVALIDDEVICE
                Exit Function
            Else
                'The display mode is higher than 8bit
                'Get the format(a unuseful ID of the D3DDM)
                vFORMAT = D3DDM.Format
                'Set the D3DPP's swapeffect to DISCARD and windowed to 1(which means yes)
                .SwapEffect = D3DSWAPEFFECT_DISCARD
                .Windowed = 1
            End If
        Else
            'If the vFORMAT isn't specified (=0) then
            'find the Display Mode (like 640, 480, 16)
            'This sub leads to another FUNCTION which will be explained later.
            If vFORMAT = 0 Then lErrNum = D3DFindMode(vWIDTH, vHEIGHT, vBPP, vFORMAT)
            'If it was not found, exit function
            If lErrNum Then
                D3DInit = D3DERR_INVALIDDEVICE
                Exit Function
            End If
            'Set the D3DPP's swapeffect to FLIP
            ' " 's backbuffercount to the argument passed to this function named vBACKBUFFERS
            ' " 's backbufferwidth and height (which basically is the display mode) to the arguments
            'Install the DepthBuffer if the argument passed to the function is not 0
            ' Note:If there IS a depthbuffer, we must ENABLE it. Explained later on.
            .SwapEffect = D3DSWAPEFFECT_FLIP
            .BackBufferCount = vBACKBUFFERS
            .BackBufferWidth = vWIDTH
            .BackBufferHeight = vHEIGHT
            If vDEPTHBUFFER > 0 Then
                .EnableAutoDepthStencil = 1
                .AutoDepthStencilFormat = vDEPTHBUFFER
            End If
        End If
        'Finally set the format of the display to the D3DPP whether windowed or not.
        .BackBufferFormat = vFORMAT
    End With

    'Device
    Set D3DDEV = D3D.CreateDevice(D3DADAPTER_DEFAULT, D3DTypeDevice, vHWND, D3DCREATE_SOFTWARE_VERTEXPROCESSING, D3DPP)

     'Set our FVF!
    D3DDEV.SetVertexShader FVF 'Our FVF constant
End Function
Private Function D3DFindMode(ByVal W As Long, ByVal H As Long, ByVal BPP As Long, ByRef FMT As Long) As Long
    Dim X As Long, y As Long
    Dim D3DDM As D3DDISPLAYMODE
    Dim FOUND As Boolean

    'Get the number of display modes
    y = D3D.GetAdapterModeCount(D3DADAPTER_DEFAULT) - 1
    'If some error happends, return error and exit function
    If Err.Number Then
        D3DFindMode = D3DERR_INVALIDCALL
        Exit Function
    End If
    'Loop through the list of display modes
    For X = 0 To y
        'Get the display mode information
        Call D3D.EnumAdapterModes(D3DADAPTER_DEFAULT, X, D3DDM)
        'Some error, then return error and exit function
        If Err.Number Then
            D3DFindMode = Err.Number
            Exit Function
        End If
        'So, now let's see if the display mode we are looking at
        'is of proper size
        If D3DDM.Width = W And D3DDM.Height = H Then
            'Now let's see if the display mode we are looking at
            'is of proper colour.
            Select Case BPP
            Case 16
                If D3DDM.Format = D3DFMT_R5G6B5 Or D3DDM.Format = D3DFMT_X1R5G5B5 Or D3DDM.Format = D3DFMT_A1R5G5B5 Or D3DDM.Format = D3DFMT_X4R4G4B4 Or D3DDM.Format = D3DFMT_A4R4G4B4 Then
                    'Display mode found at 16bit, return format and exit
                    FMT = D3DDM.Format
                    Exit Function
                End If
            Case 24
                If D3DDM.Format = D3DFMT_R8G8B8 Then
                    'Display mode found at 24bit, return format and exit
                    FMT = D3DDM.Format
                    Exit Function
                End If
            Case 32
                If D3DDM.Format = D3DFMT_X8R8G8B8 Or D3DDM.Format = D3DFMT_A8R8G8B8 Then
                    'Display mode found at 32bit, return format and exit
                    FMT = D3DDM.Format
                    Exit Function
                End If
            End Select
        End If
    Next
    'Display mode was NOT found, simply return this error, and leave.
    D3DFindMode = D3DERR_INVALIDDEVICE
End Function
